/*******************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 *******************************************************************************

   Last Modification:
    @version $Id: S3M_AP_Public.h 26975 2012-09-04 09:29:09Z Sven $

   Changes:

     Version    Date        Author   Description
     ---------------------------------------------------------------------------
    1           17.03.2008  sb      created
*******************************************************************************/

#ifndef S3M_AP_PUBLIC_H_INCLUDED
#define S3M_AP_PUBLIC_H_INCLUDED

/***************************************************************************************/
/* SIII MA CP public, constants */

#define SIII_MA_AP_PROCESS_QUEUE_NAME       "QUE_S3M_AP"


/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(SIII_MA_AP_PUBLIC)
#endif


//  SIII_MA_AP_PACKET_COMMAND_START             = 0x00004A00,

/*
 * Packet Ranges:
 */

#define SIII_MA_AP_CMD_SET_DPM_CFG_REQ                      0x00004A00
#define SIII_MA_AP_CMD_SET_DPM_CFG_CNF                      0x00004A01

#ifndef __SIII_MA_AP_PACKED_PRE
#define __SIII_MA_AP_PACKED_PRE __TLR_PACKED_PRE
#endif

#ifndef __SIII_MA_AP_PACKED_POST
#define __SIII_MA_AP_PACKED_POST __TLR_PACKED_POST
#endif

typedef __SIII_MA_AP_PACKED_PRE struct SIII_MA_AP_EXTENDED_STATUS_DATA_Ttag
{
  TLR_UINT32 ulCompleteCyclesCount;
  TLR_UINT32 ulCyclesWithLostFramesCount;

  TLR_UINT32 ulMarker0;
  TLR_UINT32 ulValidSynchInputDataExchangesCount;
  TLR_UINT32 ulCompletedSynchInputDataExchangesCount;
  TLR_UINT32 ulBlockedSynchInputDataExchangesCount;

  TLR_UINT32 ulValidSynchOutputDataExchangesCount;
  TLR_UINT32 ulCompletedSynchOutputDataExchangesCount;
  TLR_UINT32 ulBlockedSynchOutputDataExchangesCount;

  TLR_UINT32 ulMarker1;
  TLR_UINT32 ulBufferedBusInputDataExchangesCount;
  TLR_UINT32 ulBufferedBusOutputDataExchangesCount;
  TLR_UINT32 ulCompletedBusInputDataExchangesCount;

  TLR_UINT32 ulMarker2;
  TLR_UINT32 ulValidBufferedDpmInputDataExchangesCount;
  TLR_UINT32 ulBlockedBufferedDpmInputDataExchangesCount;

  TLR_UINT32 ulValidBufferedDpmOutputDataExchangesCount;
  TLR_UINT32 ulBlockedBufferedDpmOutputDataExchangesCount;

} __SIII_MA_AP_PACKED_POST SIII_MA_AP_EXTENDED_STATUS_DATA_T;

/******************************************************************************
 * Packet: SIII_MA_AP_CMD_CFG_SET_DPM_CFG_REQ/SIII_MA_CP_CMD_SET_DPM_CFG_CNF
 *
 *          Configure DPM modes
 *          - Bus-Synchronous
 *          - Buffered
 */

/* request packet */
typedef __TLR_PACKED_PRE struct SIII_MA_AP_SET_DPM_CFG_REQ_DATA_Ttag
{
  /** reserved for IO status */
  TLR_UINT32                          ulSystemFlags;
  /** watchdog time in millisecs */
  TLR_UINT32                          ulWatchdogTime;

  /* Stack configuration flags */
  TLR_UINT32                          ulStackCfgFlags;

  /* Frames Lost threshold */
  TLR_UINT32                          ulFramesLostThreshold;

  /* Threshold for bus-synchronous modes */
  TLR_UINT32                          ulBusSynchronousThreshold;

  TLR_UINT32                          ulBusSynchronousInputThreshold;

  TLR_UINT32                          ulBusSynchronousOutputThreshold;
} __TLR_PACKED_POST SIII_MA_AP_SET_DPM_CFG_REQ_DATA_T;

#define SIII_MA_AP_SET_DPM_CFG_SYSTEM_FLAGS_APP_CONTROLLED        0x00000001

#define SIII_MA_AP_SET_DPM_CFG_STACK_CFG_FLAGS_BUS_SYNCHRONOUS    0x00000001


typedef __TLR_PACKED_PRE struct SIII_MA_AP_SET_DPM_CFG_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  SIII_MA_AP_SET_DPM_CFG_REQ_DATA_T   tData;
} __TLR_PACKED_POST SIII_MA_AP_SET_DPM_CFG_REQ_T;


/* confirmation packet */
typedef __TLR_PACKED_PRE struct SIII_MA_AP_SET_DPM_CFG_CNF_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
} __TLR_PACKED_POST SIII_MA_AP_SET_DPM_CFG_CNF_T;


/* packet union */
typedef union SIII_MA_AP_SET_DPM_CFG_PCK_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;
  SIII_MA_AP_SET_DPM_CFG_REQ_T        tReq;
  SIII_MA_AP_SET_DPM_CFG_CNF_T        tCnf;
} SIII_MA_AP_SET_DPM_CFG_PCK_T;


/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(SIII_MA_AP_PUBLIC)
#endif

#endif // S3M_AP_PUBLIC_H_INCLUDED
